USE [SitecoreLocalization_Data]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TranslationQueue](
    [Id] [int] IDENTITY(1,1) NOT NULL,
    [FileUri] [nvarchar](255) NOT NULL,
    [ItemId] [nvarchar](50) NOT NULL,
    [Path] [nvarchar](max) NOT NULL,
    [SourceDatabase] [nvarchar](50) NOT NULL,
    [SourceLanguage] [nvarchar](50) NOT NULL,
    [TargetLanguage] [nvarchar](50) NOT NULL,
    [Status] [nvarchar](50) NOT NULL,
    [PercentComplete] [int] NOT NULL,
    [WordCount] [int] NOT NULL,
    [Applied] [datetime] NULL,
    [Submitted] [datetime] NOT NULL,
    [SubmittedBy] [nvarchar](50) NOT NULL,
    [Created] [datetime] NOT NULL,
    [Updated] [datetime] NOT NULL,
    [LastModified] [datetime] NOT NULL,
    [Revision] [nvarchar](50) NOT NULL,
    [MediaContent] [bit] NOT NULL,
    [LastError] [nvarchar](500) NULL,
    [Locked] [bit] NOT NULL

    CONSTRAINT [PK_TranslationQueue] PRIMARY KEY CLUSTERED
    (
        [Id] ASC
    )
    WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
ALTER TABLE [dbo].[TranslationQueue] ADD  CONSTRAINT [DF_TranslationQueue_Created]  DEFAULT (getdate()) FOR [Created]
GO
ALTER TABLE [dbo].[TranslationQueue] ADD  CONSTRAINT [DF_TranslationQueue_Updated]  DEFAULT (getdate()) FOR [Updated]
GO
ALTER TABLE [dbo].[TranslationQueue] ADD  CONSTRAINT [DF_TranslationQueue_Submitted]  DEFAULT (getdate()) FOR [Submitted]
GO
ALTER TABLE [dbo].[TranslationQueue] ADD  CONSTRAINT [DF_TranslationQueue_SubmittedBy]  DEFAULT (N'()') FOR [SubmittedBy]
GO

CREATE NONCLUSTERED INDEX [TranslationQueue_FileUri_TargetLanguage_idx] ON [TranslationQueue]
(
	[FileUri],
	[TargetLanguage]
)
GO

CREATE NONCLUSTERED INDEX [TranslationQueue_ItemId_SourceLanguage_idx] ON [TranslationQueue]
(
	[ItemId],
	[SourceLanguage]
)
GO

CREATE NONCLUSTERED INDEX [TranslationQueue_Status_idx] ON [TranslationQueue]
(
	[Status]
)
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER [dbo].[trg_SetUpdatedDate]
ON [dbo].[TranslationQueue]
AFTER UPDATE
AS
    UPDATE dbo.TranslationQueue
    SET Updated = GETUTCDATE()
    WHERE Id IN (SELECT DISTINCT Id FROM Inserted)
GO
